rh._.exports({"0":[[" ","Serial Command List"]],"1":[[" ","Serial Command List"]],"2":[[" ","Initiates camera calibration of gain, exposure, and focus. Each parameter is independent. Ranges are device-dependent."," ","-exp enable=1"," or ","disable=0"," autocalibrate exposure."," ","-expval"," value of exposure in μs."," ","-gain enable=1"," or ","disable=0"," autocalibrate gain."," ","-gainval"," value of gain in percentage."," ","-focus enable=1"," or ","disable=0"," autocalibrate focus"," ","-focval"," value of focus in mm."," ","Example 1:"," ","Command:"," AUTOCAL"," ","Response:"," 0;4632;134;50;300 (gain=0, exposure=4632 μs, focus=134, min allowable focus=50, max allowable focus=300)"," ","Example 2:"," ","Command:"," OFFLINE"," ","Response:"," !OK"," ","Command:"," QUERYAUTOCAL"," ","Response:"," 0;4632;134;50;300 (Gain was 0.)"," ","Command:"," AUTOCAL -exp=1 -gain=0 -gainval=18 (Fixed gain at 18%.)"," ","Response:"," 18;3308;128;50;300 (Gain did not change and exposure has changed from 4632 μs to 3308 μs.)"," ","Example 3:"," ","Command:"," OFFLINE"," ","Response:"," !OK"," ","Command:"," QUERYAUTOCAL"," ","Response:"," 0;3478;226;50;300 (Exposure was 3478 μs.)"," ","Command:"," AUTOCAL -exp=0 -expval=1000 (Fixed exposure at 1000 μs.)"," ","Response:"," 31;1000;98;50;300 (Exposure stayed at 1000 μs and gain has changed from 0% to 31%.)"," ","Precautions for Correct Use:"," AUTOCAL only functions when the camera is OFFLINE."],[" ","Gets value of a global tag."," ","The tagname must correspond to one of the supported tags within the device. Use the ","INFO"," command to get a full list of tags and services, as well as attributes of the tag and list of subtags."," ","The command is terminated by a carriage return and/or line feed character."," ","Include an index to get a single value from an array such as ","GET int1",". If the index is omitted, the full array of values will be returned in a comma-separated list of values."," ","Send ","Get {tagname|service.tagname|service}"," to get the value of a tag within the global data service. To get the value of a tag within another service, prefix the tagname with the service name. For example, a ","GET <service.tagname>"," command such as ","GET eip.input"," for the EIP input assembly."," ","The AVP service allows retrieval of step and datum information from the job tree using forward slash ‘/’ in the symbolic name path. ","GET avp/insp1/snapshot1/status"," paths are not case-sensitive and do not need to be fully qualified if unique."," ","GET avp/snapshot1/status"," will return the same result if there is only one inspection."," ","When issued against a step, ","GET avp/snapshot1"," will return the values for all datums."," ","Success Return:"," On success will return the value stored in the tag."," ","Example:"," ABCD"," ","Fail Return:"," On failure will return"," !ERROR"," followed by the reason for the failure."," ","Example:"," !ERROR Tag matchstring66 not found"," ","Precautions for Correct Use:"," This command only functions when the camera is ONLINE."," ","For TCP Connection:"],[" ","For UART Connection:"],[" ","Initiates serial transfer of inspection image."," ","Note:"," This command always returns the last (most recent) image."," ","-transfer=ymodem"," uses Ymodem protocol over the serial port. If the -transfer option is omitted completely, the transfer mode is over the TCP and Ethernet port."," ","Important:"," YModem transfer option is not supported on the HAWK MV-4000."," ","-format={jpg|png|raw|tif}"," specifies the format of the image. ","RAW"," and ","TIF"," are not supported over a UART Connection. If omitted, the image format is ","JPG","."," ","Note:"," For monochrome cameras, the only formats available are TIF, PNG, and JPG. For color cameras, the only formats available are RAW, and PNG."," ","Note:"," All image file types return complete file information that can be saved directly to disk except the RAW file type, which requires explicit conversion."," ","-quality=n"," specifies a JPG compression quality of n less than or equal to 100. The default quality is 80 if not specified. This setting is only supported for the JPG file type."," ","Note:"," PNG, RAW, and TIF formats provide lossless image compression. If format is set to PNG, RAW, or TIF, the quality setting does not apply."," ","-woi=left,top,right,bottom"," specifies a rectangular area of the image to be included in the output image. If omitted, the full image buffer is returned."," ","Note: -woi"," is only supported for TIF and JPG formats, as shown in the table below."," ","-inspection=n"," specifies the inspection from which to retrieve an image. The image will be from the first snapshot within that inspection. If not specified, the image will be from the first inspection that contains a snapshot."," ","The following example will retrieve an image from the camera with these settings:"," ","Protocol:"," ymodem; ","Format:"," png; ","Quality:"," N/A; ","Inspection:"," second inspection."," ","GETIMAGE –transfer=ymodem –format=png –inspection=2"," ","The following example will retrieve an image from the camera with these settings:"," ","Protocol:"," ymodem; ","Format:"," jpg (default); ","Quality:"," 50; ","Inspection:"," first inspection (default)."," ","GETIMAGE –transfer=ymodem –quality=50"," ","Precautions for Correct Use:"," This command only functions when the camera is ONLINE."],[" ","Returns a list of all serial commands showing correct syntax and functionality descriptions."],[" ","Gets information about a tag or service."," ","INFO"," with no arguments gets a list of services."," ","INFO <service>"," gets a list of tags in that service."," ","INFO <service.tagname>"," gets attributes of the tag as well as a list of subtags."," ","The AVP service allows retrieval of step and datum information from the job tree using forward slash ‘/’ in the symbolic name path. ","INFO avp/insp1/snapshot1/status"," paths are not case-sensitive and do not need to be fully qualified if unique."," ","INFO avp/snapshot1/status"," will return the same result if there is only one inspection."," ","When issued against a step, ","INFO avp/snapshot1"," returns properties of the step, a list of child datums, and a list of child steps. Child steps are indicated by a trailing forward slash."],[" ","Sets bootup job slot ","n"," (RS-232 only)."],[" ","Deletes job in slot ","n",", or all jobs if ","-all","."," ","Precautions for Correct Use:"," Does not delete the current job loaded in camera memory."],[" ","Downloads a"," .avz"," job file via the specified transfer method (ymodem supported only over RS-232; FTP supported only over network connection)."," ","The ","ymodem transfer method"," only requires that the user send the .avz file via the ymodem protocol over RS-232, and the job will load automatically after the transfer is complete."," ","The ","FTP transfer method"," requires the user to perform the following steps to load the job:"," ","JOBDOWNLOAD: -transfer=ftp [-size=avpsizeinbytes]"," ","Pre-creates a fixed-size /streamd0 RAMdisk to receive the .avz over FTP. If size is omitted, the default RAM disk size is used to create /streamd0. The size of /streamd0 is limited to (available contiguous RAM – minimum target contiguous RAM) / 2."," ","User FTPs the job to /streamd0"," ","JOBLOAD:"," ","-mem -r"," ","Loads .avz from /streamd0 into RAM, deletes the RAMDisk /streamd0, and optionally starts the job (if -r is specified)."," ","Precautions for Correct Use:"," JOBDOWNLOAD only supports FTP on the HAWK MV-4000."],[" ","Gets job summary or info about slot ","n","."," ","JOBINFO"," with no arguments returns a list of all jobs on the device."," ","-v"," = Verbose ","n",". This option shows the amount of space that would be freed if the job were deleted. It also lists the total disk space and free disk space."],[" ","Loads a job from slot n or from memory when used with the JOBDOWNLOAD command via FTP."," ","-r"," = Start inspections."],[" ","Saves current job to slot ","n","."],[" ","Saves the current job in the specified slot ","n"," with the specified name, replacing the current name of the job in that slot."],[" ","Returns available memory for device or coprocessor."],[" ","Returns maximum memory block for device or coprocessor."],[" ","Returns memory fragments for device or coprocessor."," ","Precautions for Correct Use:"," MEMFRAGS is not supported by the HAWK MV-4000. It will return"," !ERROR","."],[" ","Returns memory summary “avail/contig/frags” for device or coprocessor. Verbose."],[" ","Stops all inspections."],[" ","Starts all inspections."],[" ","Queries if each inspection on the camera is online. Defaults to all inspections if no inspection is specified. If the camera is running in a multi-inspection job, this command will return ","!1"," if all inspections are online and ","!0"," otherwise."," ","-insp=n"," specifies the inspection to query if it is online."],[" ","Returns photometry settings: Gain, Exposure, and Focus."],[" ","Queries the units being used for autofocus, mm (0) or inches (1)."],[" ","Returns white balance settings: RED gain, BLUE gain, and GREEN gain."],[" ","Performs an autofocus by analyzing the area around the point specified by ","x"," and ","y","."," ","The response is in the format of the camera’s current focus, min. allowable focus on the camera, max. allowable focus on the camera."," ","Example:"," ","Perform a quick focus on point (640,480) in the image."," ","Command:"," QUICKFOCUS 640 480"," ","Response:"," 124;50;300 (Current focus is set to 124 mm with an allowable focus range of 50 – 300 mm on the current camera.)"," ","Precautions for Correct Use:"," This command only functions when the camera is OFFLINE."],[" ","Queries if inspection is waiting for a trigger. ","!1"," if all inspections are ready or ","!0"," if not all inspections are ready."," ","-insp=n"," specifies the inspection to query if it is ready."],[" ","Reboots the device."," ","-noload"," = do not load BOOT job."],[" ","Restores preset white balance parameters:  RED gain, BLUE gain, and GREEN gain."],[" ","Sets value of a global tag."," ","The tagname must correspond to one of the supported tags within the device. Use the ","INFO"," command to get a full list of tags and services, as well as attributes of the tag and list of subtags."," ","The value can contain spaces."," ","The command is terminated by a carriage return and/or line feed character."," ","The value can be a list of comma-separated items to set a sequence of tags:"," ","Send ","SET int1 1, 2, 3"," to set int1 = 1, int2 = 2, int3 = 3."," ","The AVP service allows setting of step and datum information from the job tree using forward slash ‘/’ in the symbolic name path. ","SET avp/insp1/snapshot1/acq1/gain 2.0"," paths are not case-sensitive and do not need to be fully qualified if unique."," ","SET avp/acq1/gain"," 2.0 will set the same gain value if there is only one acquire."," ","Control tags in the AVP service such as ","START",", ","STOP",", and ","TRIGGER"," act as momentary switches. ","SET avp.start 1"," is equivalent to the ","ONLINE"," command. ","avp.start"," will reset immediately and always read as ","0","."," ","Success Return:"," On success will return"," !OK"," followed by an echo of the command."," ","Example:"," ","!OK SET matchstring1"," ","Fail Return:"," On failure will return ","!ERROR"," followed by the reason for the failure."," ","Example:"," ","!ERROR Tag matchstring66 not found"],[" ","Sets units used for autofocus, ","mm (0)"," or ","inches (1)","."," ","Precautions for Correct Use:"," The F430-F only supports mm so SETFOCUSUNITS will only accept ","0"," and anything else will respond with ","!ERROR","."],[" ","Turns targeting LEDs On or Off."," ","target 1"," = Turn Target On"," ","target 0"," = Turn Target Off"],[" ","Triggers an inspection."],[" ","Returns software version."],[" ","Triggers an inspection by pulsing a Virtual I/O point."," ","Example:"," ","vt 1"," will return pulse ","VIO1",". The inspection will run if it is configured to use ","VIO 1"," as a trigger."," ","If specified, the VIO index must be in the allowed range for Virtual I/O points. The virtual I/O line will be set high then low. ","If VIO Index is not specified, VIO1 is assumed."," ","Fail Return:"," Return ","!ERROR"," followed by the reason for the failure."," ","Example:"," ","!ERROR No such trigger"," when the index specified ‘","n","’ is out of range of virtual triggers."],[" ","Performs automatic calibration of white balance settings: RED gain, BLUE gain, and GREEN gain."," ","Precautions for Correct Use:"," This command only functions when the camera is OFFLINE."]],"6":[[" ","AUTOCAL [-exp={0|1}] [-expval={60-100000}] [-gain={0|1}] [-gainval ={0-100}] [-focus={0|1}] [-focval{0-9999}]"],[" ","GET {tagname|service|service.tagname}"],[" ","GETIMAGE [-format={jpg|png|tif|raw}] [-quality ={0-100}] [-woi=left,top,right,bottom] [-inspection=n]"],[" ","GETIMAGE <-transfer=ymodem> [-format={jpg|png}] [-quality ={0-100}] [-woi=left,top,right,bottom] [-inspection=n]"],[" ","HELP"],[" ","INFO [tagname|service]"],[" ","JOBBOOT [-slot=]<n>"],[" ","JOBDELETE {[-slot=]n|-all}"],[" ","JOBDOWNLOAD <-transfer={ymodem|ftp}> [-size=value] [-c]"],[" ","JOBINFO [[-slot=]n] [-v]"],[" ","JOBLOAD {[-slot=]<n>|-mem} [-r]"],[" ","JOBSAVE [-slot=]<n>"],[" ","JOBSAVEAS -slot=<n> -name=<name>"],[" ","MEMAVAIL [-cp]"],[" ","MEMCONTIG [-cp]"],[" ","MEMFRAGS [-cp]"],[" ","MEMINFO [-cp] [-v]"],[" ","OFFLINE"],[" ","ONLINE"],[" ","ONLINE? [-insp=n]"],[" ","QUERYAUTOCAL"],[" ","QUERYFOCUSUNITS"],[" ","QUERYWHITEBAL"],[" ","QUICKFOCUS [x] [y]"],[" ","READY? [-insp=n]"],[" ","REBOOT [-noload]"],[" ","RESTOREWBAL"],[" ","SET <tagname> <value>"],[" ","SETFOCUSUNITS"],[" ","TARGET {0|1|off|on}"],[" ","TRIGGER"],[" ","VERSION"],[" ","vt [n]"],[" ","WHITEBAL"]],"id":"182"})